/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.misc;

import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ClientComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentEventMap;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSink;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSource;
import com.technicalitiesmc.lib.circuit.interfaces.wire.BundledWire;
import com.technicalitiesmc.lib.circuit.interfaces.wire.RedstoneWire;
import com.technicalitiesmc.lib.circuit.interfaces.wire.Wire;
import com.technicalitiesmc.lib.init.TKLibItemTags;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.scm.component.CircuitComponentBase;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import com.technicalitiesmc.scm.init.SCMComponents;
import com.technicalitiesmc.scm.init.SCMItems;
import java.util.function.BiFunction;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class PlatformComponent
extends CircuitComponentBase<PlatformComponent> {
    private static final AABB BOUNDS = new AABB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
    private static final Property<Boolean> PROP_CONDUCTIVE = BooleanProperty.m_61465_((String)"conductive");
    private static final InterfaceLookup<PlatformComponent> INTERFACES = InterfaceLookup.builder().with(RedstoneSource.class, VecDirectionFlags.verticals(), PlatformComponent.makePassThrough(RedstoneSource.class)).with(RedstoneSink.class, VecDirectionFlags.verticals(), PlatformComponent.makePassThrough(RedstoneSink.class)).with(Wire.class, VecDirectionFlags.verticals(), PlatformComponent.makePassThrough(Wire.class)).with(RedstoneWire.class, VecDirectionFlags.verticals(), PlatformComponent.makePassThrough(RedstoneWire.class)).with(BundledWire.class, VecDirectionFlags.verticals(), PlatformComponent.makePassThrough(BundledWire.class)).build();
    private boolean conductive = true;

    public PlatformComponent(ComponentContext context) {
        super(SCMComponents.PLATFORM, context, INTERFACES);
    }

    private PlatformComponent(ComponentContext context, boolean conductive) {
        this(context);
        this.conductive = conductive;
    }

    public CircuitComponent copyRotated(ComponentContext context, Rotation rotation) {
        return new PlatformComponent(context, this.conductive);
    }

    public ComponentState getState() {
        return (ComponentState)super.getState().m_61124_(PROP_CONDUCTIVE, (Comparable)Boolean.valueOf(this.conductive));
    }

    public AABB getBoundingBox() {
        return BOUNDS;
    }

    public ItemStack getPickedItem() {
        return new ItemStack((ItemLike)SCMItems.PLATFORM.get());
    }

    public boolean isTopSolid() {
        return true;
    }

    public void receiveEvent(VecDirection side, CircuitEvent event, ComponentEventMap.Builder builder) {
        CircuitComponent neighbor;
        if (this.conductive && side.getAxis() == Direction.Axis.Y && (neighbor = this.getOppositeNeighbor(side)) != null) {
            this.sendEvent(event, new VecDirection[]{side.getOpposite()});
        }
    }

    public InteractionResult use(Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_204117_(TKLibItemTags.TOOLS_WRENCH)) {
            this.updateExternalState(true, () -> {
                this.conductive = !this.conductive;
            });
            this.sendEvent(CircuitEvent.NEIGHBOR_CHANGED, VecDirectionFlags.verticals());
            this.sendEvent(CircuitEvent.REDSTONE, VecDirectionFlags.verticals());
        }
        return super.use(player, hand, sideHit, hit);
    }

    public CompoundTag save(CompoundTag tag) {
        tag.m_128379_("conductive", this.conductive);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.conductive = tag.m_128471_("conductive");
    }

    private CircuitComponent getOppositeNeighbor(VecDirection side) {
        return this.findNeighbor(side.getOpposite());
    }

    private static <T> BiFunction<PlatformComponent, VecDirection, T> makePassThrough(Class<T> type) {
        return (comp, side) -> {
            if (!comp.conductive) {
                return null;
            }
            CircuitComponent neighbor = comp.getOppositeNeighbor((VecDirection)side);
            return neighbor == null ? null : neighbor.getInterface(side, type);
        };
    }

    public static void createState(StateDefinition.Builder<ComponentType, ComponentState> builder) {
        builder.m_61104_(new Property[]{PROP_CONDUCTIVE});
    }

    public static class Client
    extends ClientComponent {
        public boolean isTopSolid(ComponentState state) {
            return true;
        }

        public AABB getBoundingBox(ComponentState state) {
            return BOUNDS;
        }

        public ItemStack getPickedItem(ComponentState state) {
            return new ItemStack((ItemLike)SCMItems.PLATFORM.get());
        }

        public InteractionResult use(ComponentState state, Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_41619_() && stack.m_204117_(TKLibItemTags.TOOLS_WRENCH)) {
                return InteractionResult.m_19078_((boolean)true);
            }
            return super.use(state, player, hand, sideHit, hit);
        }
    }
}

